/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm;

import com.sun.comm.Portmapping;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.ParallelPort;
import javax.comm.ParallelPortEvent;
import javax.comm.ParallelPortEventListener;
import javax.comm.UnsupportedCommOperationException;

class LinuxParallel
extends ParallelPort {
    private int port_mode = 1;
    private int port_fd = 0;
    private int rcv_timeout = 0;
    private int rcv_threshold = 0;
    private int framing_byte = -1;
    private int ibuffer_size = 1024;
    private int obuffer_size = 1024;
    public static final int LPT_MODE_ANY = 0;
    public static final int LPT_MODE_SPP = 1;
    public static final int LPT_MODE_PS2 = 2;
    public static final int LPT_MODE_EPP = 3;
    public static final int LPT_MODE_ECP = 4;
    private static final int STATUS_PaperOut = 1;
    private static final int STATUS_PrtBusy = 2;
    private static final int STATUS_PrtSelected = 4;
    private static final int STATUS_PrtTimedOut = 8;
    private static final int STATUS_PrtError = 16;
    private ParallelPortEventListener listener = null;
    private LPInputStream inputStream = null;
    private LPOutputStream outputStream = null;
    private int notificationMask = 0;
    private static final int NOTIFY_ERR = 1;
    private static final int NOTIFY_BUF = 2;

    public LinuxParallel(String theName) throws IOException {
        this.name = theName;
        if (this.port_fd != 0) {
            return;
        }
        String portName = Portmapping.translatePortname(theName);
        if (System.getProperty("debug_portmap") != null) {
            System.err.println("LinuxParallel(" + theName + ") = " + portName);
        }
        try {
            this.port_fd = this.nativeOpenPort(portName);
        }
        catch (IOException e) {
            throw new IOException("  Error opening\"" + portName + "\"\n  " + e.getMessage());
        }
    }

    private native int nativeOpenPort(String var1) throws IOException;

    public int getOutputBufferFree() {
        return 512;
    }

    public int setMode(int mode) throws UnsupportedCommOperationException {
        switch (mode) {
            case 0: {
                this.port_mode = 1;
                break;
            }
            case 1: {
                this.port_mode = 1;
                break;
            }
            case 2: {
                this.port_mode = 2;
                break;
            }
            default: {
                throw new UnsupportedCommOperationException("mode not supported");
            }
        }
        return this.port_mode;
    }

    public int getMode() {
        return this.port_mode;
    }

    public void suspend() {
    }

    public void restart() {
    }

    private native boolean nativeGetStatusFlags(int var1, int var2);

    public boolean isPaperOut() {
        if (this.port_fd > 0) {
            return this.nativeGetStatusFlags(this.port_fd, 1);
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    public boolean isPrinterBusy() {
        if (this.port_fd > 0) {
            return this.nativeGetStatusFlags(this.port_fd, 2);
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    public boolean isPrinterSelected() {
        if (this.port_fd > 0) {
            return this.nativeGetStatusFlags(this.port_fd, 4);
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    public boolean isPrinterTimedOut() {
        if (this.port_fd > 0) {
            return this.nativeGetStatusFlags(this.port_fd, 8);
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    public boolean isPrinterError() {
        if (this.port_fd > 0) {
            return this.nativeGetStatusFlags(this.port_fd, 16);
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    public void addEventListener(ParallelPortEventListener lsnr) throws TooManyListenersException {
        if (this.port_fd > 0) {
            if (this.listener != null) {
                throw new TooManyListenersException("only one listner is allowed");
            }
        } else {
            throw new IllegalStateException("This port has not been opened yet");
        }
        this.listener = lsnr;
    }

    public void removeEventListener() {
        this.listener = null;
    }

    private void raiseEvent(int notify_bit, boolean oldvalue, boolean newvalue) {
        int eventtype = 0;
        if (this.listener != null && (this.notificationMask & notify_bit) > 0) {
            switch (notify_bit) {
                case 1: {
                    eventtype = 1;
                    break;
                }
                case 2: {
                    eventtype = 2;
                    break;
                }
                default: {
                    return;
                }
            }
            this.listener.parallelEvent(new ParallelPortEvent(this, eventtype, oldvalue, newvalue));
        }
    }

    public void notifyOnError(boolean enable) {
        this.notificationMask &= 0xFFFFFFFE;
        if (enable) {
            this.notificationMask |= 1;
        }
    }

    public void notifyOnBuffer(boolean enable) {
        this.notificationMask &= 0xFFFFFFFD;
        if (enable) {
            this.notificationMask |= 2;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.port_fd > 0) {
            if (this.port_mode == 2) {
                if (this.inputStream == null) {
                    this.inputStream = new LPInputStream();
                }
                return this.inputStream;
            }
            throw new IOException("This port is not in bidirectional mode");
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.port_fd > 0) {
            if (this.outputStream == null) {
                this.outputStream = new LPOutputStream();
            }
            return this.outputStream;
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    public void close() {
        try {
            if (this.port_fd <= 0) {
                throw new IllegalStateException("This port has not been opened yet");
            }
            this.nativeClosePort(this.port_fd);
            this.port_fd = 0;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        super.close();
    }

    private native void nativeClosePort(int var1) throws IOException;

    private native int nativeAvailable(int var1) throws IOException;

    private native byte nativeReadByte(int var1) throws IOException;

    private native int nativeRead(int var1, byte[] var2, int var3, int var4) throws IOException;

    public native int nativeWrite(int var1, byte[] var2, int var3, int var4) throws IOException;

    public void enableReceiveThreshold(int thresh) throws UnsupportedCommOperationException {
        if (this.port_mode == 2) {
            throw new UnsupportedCommOperationException("Receive threshold has not been supported yet");
        }
        throw new IllegalStateException("This port is not in bidirectional mode");
    }

    public void disableReceiveThreshold() {
        if (this.port_mode != 2) {
            throw new IllegalStateException("This port is not in bidirectional mode");
        }
        this.rcv_threshold = 0;
    }

    public boolean isReceiveThresholdEnabled() {
        return false;
    }

    public int getReceiveThreshold() {
        return this.rcv_threshold;
    }

    public void enableReceiveTimeout(int rcvTimeout) {
        if (this.port_mode == 2) {
            this.rcv_timeout = rcvTimeout;
            if (this.port_fd <= 0) {
                throw new IllegalStateException("This port has not been opened yet");
            }
        } else {
            throw new IllegalStateException("The port mode is not bidirectional");
        }
        this.nativeSetTimeout(this.port_fd, this.rcv_timeout * 1000);
    }

    public void disableReceiveTimeout() {
        if (this.port_mode == 2) {
            this.rcv_timeout = 0;
            if (this.port_fd <= 0) {
                throw new IllegalStateException("This port has not been opened yet");
            }
        } else {
            throw new IllegalStateException("The port mode is not bidirectional");
        }
        this.nativeSetTimeout(this.port_fd, this.rcv_timeout);
    }

    public boolean isReceiveTimeoutEnabled() {
        return this.rcv_timeout > 0;
    }

    public int getReceiveTimeout() {
        return this.rcv_timeout;
    }

    private native void nativeSetTimeout(int var1, int var2);

    public void disableReceiveFraming() {
        if (this.port_mode != 2) {
            throw new IllegalStateException("This port has not been opened yet");
        }
        this.framing_byte = -1;
    }

    public void enableReceiveFraming(int framingByte) throws UnsupportedCommOperationException {
        if (this.port_mode == 2) {
            this.framing_byte = -1;
            throw new UnsupportedCommOperationException("Receive framing has not been supported yet");
        }
        throw new IllegalStateException("This port has not been opened yet");
    }

    public boolean isReceiveFramingEnabled() {
        return false;
    }

    public int getReceiveFramingByte() {
        return this.framing_byte;
    }

    public void setInputBufferSize(int size) {
        this.ibuffer_size = size;
    }

    public int getInputBufferSize() {
        return this.ibuffer_size;
    }

    public void setOutputBufferSize(int size) {
        this.obuffer_size = size;
    }

    public int getOutputBufferSize() {
        return this.obuffer_size;
    }

    class LPOutputStream
    extends OutputStream {
        LPOutputStream() {
        }

        public void write(int b) throws IOException {
            byte[] buf = new byte[]{(byte)b};
            if (LinuxParallel.this.port_fd > 0) {
                int status = LinuxParallel.this.nativeWrite(LinuxParallel.this.port_fd, buf, 0, 1);
                if (status != 1) {
                    throw new IOException("write to parallel port failed");
                }
            } else {
                throw new IllegalStateException("This port is closed");
            }
        }

        public void write(byte[] b, int offset, int len) throws IOException {
            int write_up_to = len;
            int status = 0;
            if (b != null) {
                if (len + offset > b.length) {
                    write_up_to = b.length - offset;
                }
                if (LinuxParallel.this.port_fd > 0) {
                    status = LinuxParallel.this.nativeWrite(LinuxParallel.this.port_fd, b, offset, write_up_to);
                    if (status != write_up_to) {
                        throw new IOException("write to parallel port failed");
                    }
                } else {
                    throw new IllegalStateException("This port has not been closed");
                }
            }
        }
    }

    class LPInputStream
    extends InputStream {
        private byte[] buf = null;

        LPInputStream() {
        }

        public int available() throws IOException {
            if (LinuxParallel.this.port_fd != 0) {
                return LinuxParallel.this.nativeAvailable(LinuxParallel.this.port_fd);
            }
            throw new IllegalStateException("This port has not been opened yet");
        }

        public int read(byte[] b, int offset, int len) throws IOException {
            int read_up_to = len;
            int status = 0;
            if (b == null) {
                b = new byte[len + offset];
            }
            if (len + offset > b.length) {
                read_up_to = b.length - offset;
            }
            try {
                if (LinuxParallel.this.port_fd <= 0) {
                    throw new IllegalStateException("This port has not been opened yet");
                }
                status = LinuxParallel.this.nativeRead(LinuxParallel.this.port_fd, b, offset, read_up_to);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw ioe;
            }
            return status;
        }

        public int read() throws IOException {
            if (LinuxParallel.this.port_fd > 0) {
                return LinuxParallel.this.nativeReadByte(LinuxParallel.this.port_fd);
            }
            throw new IllegalStateException("This port has not been opened yet");
        }
    }
}

